

<?php $__env->startSection('content'); ?>
    <h1>Menü Yönetimi</h1>
    <p>Header/Footer menülerini düzenle, öğe ekle veya güncelle. Değişiklikler cache’den otomatik temizlenir.</p>

    <div class="grid grid-2 mt">
        <div>
            <h3>Yeni Menü Oluştur</h3>
            <form method="POST" action="<?php echo e(route('admin.menus.store')); ?>">
                <?php echo csrf_field(); ?>
                <input name="name" placeholder="Menü adı (örn: Header)" required>
                <input name="slug" placeholder="Slug (örn: header)" required>
                <input name="location" placeholder="Konum (opsiyonel)">
                <label class="flex"><input type="checkbox" name="is_active" value="1" checked> Aktif</label>
                <button class="btn" type="submit">Kaydet</button>
            </form>
        </div>

        <div>
            <h3>Yeni Menü Öğesi</h3>
            <form method="POST" action="<?php echo e(route('admin.menus.items.store', ['menu' => optional($menus->first())->id])); ?>">
                <?php echo csrf_field(); ?>
                <select name="menu_id" onchange="this.form.action=this.form.action.replace(/menus\\/\\d+\\/items/, 'menus/'+this.value+'/items')">
                    <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($menu->id); ?>"><?php echo e($menu->name); ?> (<?php echo e($menu->slug); ?>)</option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <input name="title" placeholder="Başlık" required>
                <input name="url" placeholder="URL (dış link) — varsa route_name boş bırak">
                <input name="route_name" placeholder="Route adı (örn: home)">
                <input name="route_params" placeholder='Route parametreleri JSON (örn: {"slug":"ornek"})'>
                <input name="target" placeholder="Target (varsayılan: _self)">
                <select name="parent_id">
                    <option value="">Üst öğe yok</option>
                    <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $menu->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($mi->id); ?>"><?php echo e($menu->name); ?> → <?php echo e($mi->title); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <input type="number" name="order" value="0" min="0" placeholder="Sıra">
                <label class="flex"><input type="checkbox" name="is_active" value="1" checked> Aktif</label>
                <button class="btn" type="submit">Öğe Ekle</button>
            </form>
        </div>
    </div>

    <div class="mt">
        <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="mt">
                <h3><?php echo e($menu->name); ?> <small>(<?php echo e($menu->slug); ?>)</small></h3>
                <?php if($menu->items->isEmpty()): ?>
                    <p>Henüz öğe yok.</p>
                <?php else: ?>
                    <table>
                        <thead>
                            <tr>
                                <th>Başlık</th>
                                <th>URL</th>
                                <th>Route</th>
                                <th>Üst</th>
                                <th>Sıra</th>
                                <th>Aktif</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $menu->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item->title); ?></td>
                                    <td><?php echo e($item->url); ?></td>
                                    <td><?php echo e($item->route_name); ?></td>
                                    <td><?php echo e(optional($item->parent)->title); ?></td>
                                    <td><?php echo e($item->order); ?></td>
                                    <td><span class="badge"><?php echo e($item->is_active ? 'Aktif' : 'Pasif'); ?></span></td>
                                    <td class="flex">
                                        <form method="POST" action="<?php echo e(route('admin.menus.items.update', $item)); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <input type="hidden" name="title" value="<?php echo e($item->title); ?>">
                                            <input type="hidden" name="url" value="<?php echo e($item->url); ?>">
                                            <input type="hidden" name="route_name" value="<?php echo e($item->route_name); ?>">
                                            <input type="hidden" name="route_params" value="<?php echo e($item->route_params ? json_encode($item->route_params) : ''); ?>">
                                            <input type="hidden" name="parent_id" value="<?php echo e($item->parent_id); ?>">
                                            <input type="hidden" name="order" value="<?php echo e($item->order); ?>">
                                            <input type="hidden" name="target" value="<?php echo e($item->target); ?>">
                                            <input type="hidden" name="is_active" value="<?php echo e($item->is_active); ?>">
                                            <button class="btn secondary" type="submit">Yenile</button>
                                        </form>
                                        <form method="POST" action="<?php echo e(route('admin.menus.items.destroy', $item)); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button class="btn danger" type="submit" onclick="return confirm('Silinsin mi?')">Sil</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/admin/menus/index.blade.php ENDPATH**/ ?>