
<?php $__env->startSection('content'); ?>
<?php if($page->content && !$trackingCode): ?>
    <?php echo $page->content; ?>

<?php else: ?>
<div class="tm-page-container" style="max-width:900px;margin:50px auto;padding:30px;">
    <h1 style="margin:0 0 30px;color:#414141;font-size:28px;font-weight:600;text-align:center;"><?php echo e($page->title); ?></h1>
    
    <div style="background:#fff;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);padding:40px;margin-bottom:30px;">
        <form method="GET" action="<?php echo e(route('pages.siparis-takip')); ?>" style="display:flex;gap:12px;max-width:600px;margin:0 auto;">
            <input type="text" name="code" value="<?php echo e($trackingCode); ?>" placeholder="Takip kodunuzu girin (örn: TRK-12345678)" 
                   style="flex:1;padding:14px 16px;border:2px solid #e5e7eb;border-radius:4px;font-size:15px;box-sizing:border-box;"
                   onfocus="this.style.borderColor='#7db64f'" onblur="this.style.borderColor='#e5e7eb'">
            <button type="submit" style="padding:14px 24px;background:#7db64f;color:#fff;border:none;border-radius:4px;font-size:15px;font-weight:600;cursor:pointer;white-space:nowrap;">
                Sorgula
            </button>
        </form>
    </div>

    <?php if($trackingCode && !$order): ?>
        <div style="background:#f8d7da;color:#721c24;padding:16px;border-radius:4px;margin-bottom:20px;border:1px solid #f5c6cb;">
            <strong>Uyarı:</strong> Girilen takip kodu ile eşleşen bir sipariş bulunamadı. Lütfen takip kodunuzu kontrol edin.
        </div>
    <?php endif; ?>

    <?php if($order): ?>
        <div style="background:#fff;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);padding:30px;margin-bottom:20px;">
            <h2 style="margin:0 0 20px;color:#414141;font-size:20px;font-weight:600;">Sipariş Bilgileri</h2>
            <div style="display:grid;grid-template-columns:repeat(auto-fit, minmax(200px, 1fr));gap:20px;margin-bottom:20px;">
                <div>
                    <div style="font-size:12px;color:#666;margin-bottom:4px;">Sipariş No</div>
                    <div style="font-weight:600;color:#414141;font-size:16px;"><?php echo e($order->order_number); ?></div>
                </div>
                <div>
                    <div style="font-size:12px;color:#666;margin-bottom:4px;">Takip Kodu</div>
                    <div style="font-weight:600;color:#7db64f;font-size:16px;"><?php echo e($order->tracking_code); ?></div>
                </div>
                <div>
                    <div style="font-size:12px;color:#666;margin-bottom:4px;">Sipariş Tarihi</div>
                    <div style="font-weight:600;color:#414141;"><?php echo e($order->created_at->format('d.m.Y H:i')); ?></div>
                </div>
                <div>
                    <div style="font-size:12px;color:#666;margin-bottom:4px;">Durum</div>
                    <div style="font-weight:600;color:#414141;">
                        <?php if($order->status == 'pending'): ?> Beklemede
                        <?php elseif($order->status == 'confirmed'): ?> Onaylandı
                        <?php elseif($order->status == 'processing'): ?> Hazırlanıyor
                        <?php elseif($order->status == 'shipped'): ?> Kargoda
                        <?php elseif($order->status == 'delivered'): ?> Teslim Edildi
                        <?php elseif($order->status == 'cancelled'): ?> İptal Edildi
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div style="border-top:1px solid #e5e7eb;padding-top:20px;margin-top:20px;">
                <div style="font-size:12px;color:#666;margin-bottom:4px;">Toplam Tutar</div>
                <div style="font-weight:600;color:#7db64f;font-size:24px;"><?php echo e(number_format($order->total, 2)); ?> ₺</div>
            </div>
        </div>

        <?php if($order->items->count() > 0): ?>
        <div style="background:#fff;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);padding:30px;">
            <h2 style="margin:0 0 20px;color:#414141;font-size:20px;font-weight:600;">Sipariş Edilen Ürünler</h2>
            <div style="display:flex;flex-direction:column;gap:12px;">
                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div style="display:flex;justify-content:space-between;align-items:center;padding:12px;background:#f9f9f9;border-radius:4px;">
                        <div>
                            <div style="font-weight:600;color:#414141;"><?php echo e($item->product_name); ?></div>
                            <div style="font-size:14px;color:#666;">Adet: <?php echo e($item->quantity); ?></div>
                        </div>
                        <div style="font-weight:600;color:#7db64f;"><?php echo e(number_format($item->price * $item->quantity, 2)); ?> ₺</div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>
    <?php endif; ?>
<?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/pages/siparis-takip.blade.php ENDPATH**/ ?>