
<?php $__env->startSection('member-content'); ?>
<h1 style="margin:0 0 30px;color:#414141;font-size:24px;font-weight:600;">Siparişlerim</h1>

<?php if($orders->count() > 0): ?>
    <div style="display:flex;flex-direction:column;gap:16px;">
        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div style="border:1px solid #e5e7eb;border-radius:8px;padding:20px;transition:box-shadow 0.3s;" onmouseover="this.style.boxShadow='0 4px 12px rgba(0,0,0,0.1)'" onmouseout="this.style.boxShadow='none'">
                <div style="display:flex;justify-content:space-between;align-items:start;margin-bottom:16px;flex-wrap:wrap;gap:12px;">
                    <div>
                        <div style="font-weight:600;color:#414141;font-size:18px;margin-bottom:4px;">Sipariş #<?php echo e($order->order_number); ?></div>
                        <div style="font-size:14px;color:#666;"><?php echo e($order->created_at->format('d.m.Y H:i')); ?></div>
                    </div>
                    <div style="display:flex;gap:12px;align-items:center;flex-wrap:wrap;">
                        <span style="display:inline-block;padding:6px 16px;background:#f0f0f0;border-radius:4px;font-size:13px;font-weight:600;color:#414141;">
                            <?php if($order->status == 'pending'): ?> Beklemede
                            <?php elseif($order->status == 'confirmed'): ?> Onaylandı
                            <?php elseif($order->status == 'processing'): ?> Hazırlanıyor
                            <?php elseif($order->status == 'shipped'): ?> Kargoda
                            <?php elseif($order->status == 'delivered'): ?> Teslim Edildi
                            <?php elseif($order->status == 'cancelled'): ?> İptal Edildi
                            <?php endif; ?>
                        </span>
                        <span style="display:inline-block;padding:6px 16px;background:#e8f5e9;border-radius:4px;font-size:13px;font-weight:600;color:#2e7d32;">
                            <?php if($order->payment_status == 'paid'): ?> Ödendi
                            <?php elseif($order->payment_status == 'pending'): ?> Ödeme Bekleniyor
                            <?php elseif($order->payment_status == 'failed'): ?> Ödeme Başarısız
                            <?php elseif($order->payment_status == 'refunded'): ?> İade Edildi
                            <?php endif; ?>
                        </span>
                    </div>
                </div>

                <div style="border-top:1px solid #e5e7eb;padding-top:16px;margin-top:16px;">
                    <div style="display:grid;grid-template-columns:repeat(auto-fit, minmax(200px, 1fr));gap:16px;margin-bottom:16px;">
                        <div>
                            <div style="font-size:12px;color:#666;margin-bottom:4px;">Ürün Sayısı</div>
                            <div style="font-weight:600;color:#414141;"><?php echo e($order->items->count()); ?> ürün</div>
                        </div>
                        <div>
                            <div style="font-size:12px;color:#666;margin-bottom:4px;">Toplam Tutar</div>
                            <div style="font-weight:600;color:#7db64f;font-size:18px;"><?php echo e(number_format($order->total, 2)); ?> ₺</div>
                        </div>
                    </div>

                    <div style="display:flex;gap:12px;flex-wrap:wrap;">
                        <a href="<?php echo e(route('member.orders.show', $order)); ?>" style="display:inline-block;padding:10px 20px;background:#7db64f;color:#fff;text-decoration:none;border-radius:4px;font-weight:600;font-size:14px;">Detayları Gör</a>
                        <?php if($order->status == 'delivered'): ?>
                            <a href="<?php echo e(route('member.returns.create', $order)); ?>" style="display:inline-block;padding:10px 20px;background:#fff;color:#7db64f;text-decoration:none;border-radius:4px;font-weight:600;font-size:14px;border:2px solid #7db64f;">İade/Değişim</a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div style="margin-top:30px;">
        <?php echo e($orders->links()); ?>

    </div>
<?php else: ?>
    <div style="text-align:center;padding:60px 20px;color:#666;">
        <div style="font-size:64px;margin-bottom:20px;">📦</div>
        <div style="font-size:20px;margin-bottom:12px;color:#414141;font-weight:600;">Henüz siparişiniz bulunmuyor</div>
        <div style="font-size:14px;margin-bottom:24px;">İlk siparişinizi vermek için alışverişe başlayın</div>
        <a href="<?php echo e(route('home')); ?>" style="display:inline-block;padding:12px 24px;background:#7db64f;color:#fff;text-decoration:none;border-radius:4px;font-weight:600;">Alışverişe Başla</a>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('member.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/member/orders/index.blade.php ENDPATH**/ ?>