@extends('layouts.app')
@section('content')
@if($page->content && !$trackingCode)
    {!! $page->content !!}
@else
<div class="tm-page-container" style="max-width:900px;margin:50px auto;padding:30px;">
    <h1 style="margin:0 0 30px;color:#414141;font-size:28px;font-weight:600;text-align:center;">{{ $page->title }}</h1>
    
    <div style="background:#fff;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);padding:40px;margin-bottom:30px;">
        <form method="GET" action="{{ route('pages.siparis-takip') }}" style="display:flex;gap:12px;max-width:600px;margin:0 auto;">
            <input type="text" name="code" value="{{ $trackingCode }}" placeholder="Takip kodunuzu girin (örn: TRK-12345678)" 
                   style="flex:1;padding:14px 16px;border:2px solid #e5e7eb;border-radius:4px;font-size:15px;box-sizing:border-box;"
                   onfocus="this.style.borderColor='#7db64f'" onblur="this.style.borderColor='#e5e7eb'">
            <button type="submit" style="padding:14px 24px;background:#7db64f;color:#fff;border:none;border-radius:4px;font-size:15px;font-weight:600;cursor:pointer;white-space:nowrap;">
                Sorgula
            </button>
        </form>
    </div>

    @if($trackingCode && !$order)
        <div style="background:#f8d7da;color:#721c24;padding:16px;border-radius:4px;margin-bottom:20px;border:1px solid #f5c6cb;">
            <strong>Uyarı:</strong> Girilen takip kodu ile eşleşen bir sipariş bulunamadı. Lütfen takip kodunuzu kontrol edin.
        </div>
    @endif

    @if($order)
        <div style="background:#fff;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);padding:30px;margin-bottom:20px;">
            <h2 style="margin:0 0 20px;color:#414141;font-size:20px;font-weight:600;">Sipariş Bilgileri</h2>
            <div style="display:grid;grid-template-columns:repeat(auto-fit, minmax(200px, 1fr));gap:20px;margin-bottom:20px;">
                <div>
                    <div style="font-size:12px;color:#666;margin-bottom:4px;">Sipariş No</div>
                    <div style="font-weight:600;color:#414141;font-size:16px;">{{ $order->order_number }}</div>
                </div>
                <div>
                    <div style="font-size:12px;color:#666;margin-bottom:4px;">Takip Kodu</div>
                    <div style="font-weight:600;color:#7db64f;font-size:16px;">{{ $order->tracking_code }}</div>
                </div>
                <div>
                    <div style="font-size:12px;color:#666;margin-bottom:4px;">Sipariş Tarihi</div>
                    <div style="font-weight:600;color:#414141;">{{ $order->created_at->format('d.m.Y H:i') }}</div>
                </div>
                <div>
                    <div style="font-size:12px;color:#666;margin-bottom:4px;">Durum</div>
                    <div style="font-weight:600;color:#414141;">
                        @if($order->status == 'pending') Beklemede
                        @elseif($order->status == 'confirmed') Onaylandı
                        @elseif($order->status == 'processing') Hazırlanıyor
                        @elseif($order->status == 'shipped') Kargoda
                        @elseif($order->status == 'delivered') Teslim Edildi
                        @elseif($order->status == 'cancelled') İptal Edildi
                        @endif
                    </div>
                </div>
            </div>
            <div style="border-top:1px solid #e5e7eb;padding-top:20px;margin-top:20px;">
                <div style="font-size:12px;color:#666;margin-bottom:4px;">Toplam Tutar</div>
                <div style="font-weight:600;color:#7db64f;font-size:24px;">{{ number_format($order->total, 2) }} ₺</div>
            </div>
        </div>

        @if($order->items->count() > 0)
        <div style="background:#fff;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);padding:30px;">
            <h2 style="margin:0 0 20px;color:#414141;font-size:20px;font-weight:600;">Sipariş Edilen Ürünler</h2>
            <div style="display:flex;flex-direction:column;gap:12px;">
                @foreach($order->items as $item)
                    <div style="display:flex;justify-content:space-between;align-items:center;padding:12px;background:#f9f9f9;border-radius:4px;">
                        <div>
                            <div style="font-weight:600;color:#414141;">{{ $item->product_name }}</div>
                            <div style="font-size:14px;color:#666;">Adet: {{ $item->quantity }}</div>
                        </div>
                        <div style="font-weight:600;color:#7db64f;">{{ number_format($item->price * $item->quantity, 2) }} ₺</div>
                    </div>
                @endforeach
            </div>
        </div>
        @endif
    @endif
@endif
</div>
@endsection

