@extends('layouts.app')
@section('content')
    <style>
        .campaigns-wrapper { max-width: 1200px; margin: 0 auto; padding: 30px 16px; }
        
        .page-header { margin-bottom: 30px; text-align: center; }
        .page-header h1 { font-size: 36px; font-weight: 700; color: #333; margin-bottom: 10px; }
        .page-header p { font-size: 16px; color: #666; }
        
        .campaigns-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(350px, 1fr)); gap: 30px; margin-bottom: 40px; }
        
        .campaign-card { background: #fff; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 12px rgba(0,0,0,0.1); transition: all 0.3s; position: relative; }
        .campaign-card:hover { transform: translateY(-5px); box-shadow: 0 8px 24px rgba(0,0,0,0.15); }
        
        .campaign-image { width: 100%; height: 200px; object-fit: cover; }
        .campaign-content { padding: 20px; }
        .campaign-badge { display: inline-block; background: #ff6b35; color: #fff; padding: 6px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; margin-bottom: 12px; }
        .campaign-title { font-size: 22px; font-weight: 700; color: #333; margin-bottom: 10px; line-height: 1.3; }
        .campaign-description { font-size: 14px; color: #666; line-height: 1.6; margin-bottom: 15px; }
        .campaign-discount { font-size: 32px; font-weight: 700; color: #73ae43; margin-bottom: 15px; }
        .campaign-dates { font-size: 12px; color: #999; margin-bottom: 15px; }
        .campaign-button { display: block; background: #ff6b35; color: #fff; padding: 12px 24px; border-radius: 6px; text-align: center; text-decoration: none; font-weight: 600; transition: all 0.3s; }
        .campaign-button:hover { background: #e55a2b; transform: translateY(-2px); }
        
        .empty-state { text-align: center; padding: 60px 20px; background: #f0f9f4; border-radius: 12px; }
        .empty-state-icon { font-size: 64px; margin-bottom: 20px; }
        .empty-state h2 { font-size: 24px; color: #333; margin-bottom: 10px; }
        .empty-state p { color: #666; }
    </style>

    <div class="campaigns-wrapper">
        <div class="page-header">
            <h1>Kampanyalar</h1>
            <p>Aktif kampanyalarımızı keşfedin ve özel fırsatları kaçırmayın!</p>
        </div>

        @if($campaigns->count() > 0)
            <div class="campaigns-grid">
                @foreach($campaigns as $campaign)
                    <div class="campaign-card">
                        @if($campaign->image)
                            <img src="{{ asset($campaign->image) }}" alt="{{ $campaign->title }}" class="campaign-image">
                        @endif
                        <div class="campaign-content">
                            @if($campaign->discount_percentage)
                                <span class="campaign-badge">%{{ $campaign->discount_percentage }} İndirim</span>
                            @elseif($campaign->discount_amount)
                                <span class="campaign-badge">₺{{ number_format($campaign->discount_amount, 2) }} İndirim</span>
                            @endif
                            
                            <h2 class="campaign-title">{{ $campaign->title }}</h2>
                            
                            @if($campaign->description)
                                <p class="campaign-description">{{ $campaign->description }}</p>
                            @endif
                            
                            @if($campaign->start_date || $campaign->end_date)
                                <div class="campaign-dates">
                                    @if($campaign->start_date)
                                        Başlangıç: {{ $campaign->start_date->format('d.m.Y') }}
                                    @endif
                                    @if($campaign->end_date)
                                        @if($campaign->start_date) - @endif
                                        Bitiş: {{ $campaign->end_date->format('d.m.Y') }}
                                    @endif
                                </div>
                            @endif
                            
                            <a href="{{ route('campaigns.show', $campaign->slug) }}" class="campaign-button">
                                {{ $campaign->button_text ?? 'Detayları Gör' }}
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
            
            <div style="display: flex; justify-content: center; margin-top: 30px;">
                {{ $campaigns->links() }}
            </div>
        @else
            <div class="empty-state">
                <div class="empty-state-icon">🎁</div>
                <h2>Henüz kampanya yok</h2>
                <p>Yakında harika kampanyalar sizleri bekliyor olacak!</p>
            </div>
        @endif
    </div>
@endsection

