@extends('admin.layout')
@section('content')
<h1>Slider Yönetimi</h1>
<div class="mt">
    <a class="btn" href="{{ route('admin.sliders.create') }}">Yeni Slider Ekle</a>
</div>

@if(session('success'))
    <div class="alert alert-success mt">{{ session('success') }}</div>
@endif

@if($errors->any())
    <div class="alert alert-danger mt">
        <ul style="margin:0;padding-left:20px;">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<div class="mt" style="background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:20px;">
    @forelse($sliders as $slider)
        <div style="border:1px solid #e5e7eb;border-radius:6px;padding:20px;margin-bottom:20px;background:#f9fafb;">
            <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:15px;">
                <div>
                    <strong style="font-size:18px;color:#1f2937;">{{ $slider->name }}</strong>
                    <div style="font-size:12px;color:#6b7280;margin-top:4px;">
                        Tip: {{ $slider->type === 'banner' ? 'Banner' : 'Ürün Slider' }} | 
                        Sıra: {{ $slider->order }} |
                        @if($slider->is_active)
                            <span style="color:green;">Aktif</span>
                        @else
                            <span style="color:red;">Pasif</span>
                        @endif
                    </div>
                </div>
                <div style="display:flex;gap:8px;">
                    <a class="btn btn-sm" href="{{ route('admin.sliders.edit', $slider) }}">Düzenle</a>
                    <form action="{{ route('admin.sliders.destroy', $slider) }}" method="POST" style="display:inline;" onsubmit="return confirm('Bu slider\'ı silmek istediğinize emin misiniz?');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger">Sil</button>
                    </form>
                </div>
            </div>
            
            <div style="margin-top:15px;">
                <strong style="font-size:14px;color:#6b7280;display:block;margin-bottom:10px;">Slider Öğeleri ({{ $slider->items->count() }}):</strong>
                @if($slider->items->count() > 0)
                    <div style="display:grid;grid-template-columns:repeat(auto-fill, minmax(200px, 1fr));gap:15px;">
                        @foreach($slider->items as $item)
                            <div style="background:#fff;border:1px solid #e5e7eb;border-radius:6px;padding:12px;">
                                @if($slider->type === 'product' && $item->product)
                                    <img src="{{ $item->product->image ? asset($item->product->image) : asset('images/placeholder.png') }}" alt="{{ $item->product->name }}" style="width:100%;height:120px;object-fit:cover;border-radius:4px;margin-bottom:8px;">
                                    <div style="font-size:12px;font-weight:600;color:#333;margin-bottom:4px;">{{ $item->product->name }}</div>
                                    <div style="font-size:11px;color:#6b7280;">Sıra: {{ $item->order }}</div>
                                @else
                                    @if($item->image)
                                        <img src="{{ asset($item->image) }}" alt="{{ $item->title }}" style="width:100%;height:120px;object-fit:cover;border-radius:4px;margin-bottom:8px;">
                                    @endif
                                    <div style="font-size:12px;font-weight:600;color:#333;margin-bottom:4px;">{{ $item->title }}</div>
                                    <div style="font-size:11px;color:#6b7280;">Sıra: {{ $item->order }}</div>
                                @endif
                                <form action="{{ route('admin.sliders.removeItem', $item) }}" method="POST" style="margin-top:8px;" onsubmit="return confirm('Bu öğeyi silmek istediğinize emin misiniz?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" style="font-size:11px;padding:4px 8px;">Kaldır</button>
                                </form>
                            </div>
                        @endforeach
                    </div>
                @else
                    <p style="color:#9ca3af;font-size:14px;text-align:center;padding:20px;">Henüz öğe eklenmemiş.</p>
                @endif
            </div>
        </div>
    @empty
        <p style="color:#6b7280;text-align:center;padding:40px;">Henüz slider bulunmuyor. İlk slider'ı oluşturun.</p>
    @endforelse
</div>
@endsection

