@extends('admin.layout')

@section('content')
<h1>İade Talepleri Yönetimi</h1>

@if(session('success'))
    <div style="background:#d4edda;color:#155724;padding:12px;border-radius:4px;margin-bottom:20px;">
        {{ session('success') }}
    </div>
@endif

<div style="margin-bottom:20px;">
    <form method="GET" action="{{ route('admin.returns.index') }}" style="display:flex;gap:10px;flex-wrap:wrap;">
        <select name="status" style="padding:8px;border:1px solid #ddd;border-radius:4px;">
            <option value="">Tüm Durumlar</option>
            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Beklemede</option>
            <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Onaylandı</option>
            <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Reddedildi</option>
            <option value="processing" {{ request('status') == 'processing' ? 'selected' : '' }}>İşleniyor</option>
            <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Tamamlandı</option>
        </select>
        <button type="submit" class="btn">Filtrele</button>
        <a href="{{ route('admin.returns.index') }}" class="btn secondary">Temizle</a>
    </form>
</div>

@if($returns->count() > 0)
    <table style="width:100%;border-collapse:collapse;background:#fff;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
        <thead>
            <tr style="background:#f5f5f5;">
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Talep No</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Müşteri</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Sipariş No</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Tip</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Durum</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Tarih</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">İşlemler</th>
            </tr>
        </thead>
        <tbody>
            @foreach($returns as $return)
                <tr style="border-bottom:1px solid #eee;">
                    <td style="padding:12px;">{{ $return->return_number }}</td>
                    <td style="padding:12px;">{{ $return->user->name }}<br><small style="color:#666;">{{ $return->user->email }}</small></td>
                    <td style="padding:12px;">{{ $return->order->order_number }}</td>
                    <td style="padding:12px;">
                        @if($return->type == 'return') İade
                        @elseif($return->type == 'exchange') Değişim
                        @elseif($return->type == 'cancellation') İptal
                        @endif
                    </td>
                    <td style="padding:12px;">
                        <span style="padding:4px 12px;border-radius:4px;font-size:12px;
                            @if($return->status == 'pending') background:#fff3cd;color:#856404;
                            @elseif($return->status == 'approved') background:#d4edda;color:#155724;
                            @elseif($return->status == 'rejected') background:#f8d7da;color:#721c24;
                            @elseif($return->status == 'processing') background:#d1ecf1;color:#0c5460;
                            @elseif($return->status == 'completed') background:#d4edda;color:#155724;
                            @endif">
                            @if($return->status == 'pending') Beklemede
                            @elseif($return->status == 'approved') Onaylandı
                            @elseif($return->status == 'rejected') Reddedildi
                            @elseif($return->status == 'processing') İşleniyor
                            @elseif($return->status == 'completed') Tamamlandı
                            @endif
                        </span>
                    </td>
                    <td style="padding:12px;color:#666;font-size:13px;">{{ $return->created_at->format('d.m.Y H:i') }}</td>
                    <td style="padding:12px;">
                        <a href="{{ route('admin.returns.show', $return) }}" class="btn" style="padding:6px 12px;font-size:12px;">Detay</a>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div style="margin-top:20px;">
        {{ $returns->links() }}
    </div>
@else
    <p style="padding:40px;text-align:center;color:#666;">Henüz iade talebi bulunmuyor.</p>
@endif
@endsection

