@extends('admin.layout')
@section('content')
<h1>Ürün Yönetimi</h1>
<div class="mt">
    <a class="btn" href="{{ route('admin.products.create') }}">Yeni Ürün Ekle</a>
</div>

@if(session('success'))
    <div class="alert alert-success mt">{{ session('success') }}</div>
@endif

@if($errors->any())
    <div class="alert alert-danger mt">
        <ul style="margin:0;padding-left:20px;">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<div class="mt" style="background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:20px;">
    <table>
        <thead>
            <tr>
                <th>Görsel</th>
                <th>Ürün Adı</th>
                <th>Kategori</th>
                <th>Fiyat</th>
                <th>İndirimli Fiyat</th>
                <th>Stok</th>
                <th>Durum</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            @forelse($products as $product)
                <tr>
                    <td>
                        @if($product->image)
                            <img src="{{ asset($product->image) }}" alt="{{ $product->name }}" style="width:60px;height:60px;object-fit:cover;border-radius:4px;">
                        @else
                            <div style="width:60px;height:60px;background:#e5e7eb;border-radius:4px;display:flex;align-items:center;justify-content:center;color:#9ca3af;">Görsel Yok</div>
                        @endif
                    </td>
                    <td>
                        <strong>{{ $product->name }}</strong>
                        <div style="font-size:12px;color:#6b7280;margin-top:4px;">
                            @if($product->is_organic)
                                <span style="color:#10b981;">🌿 Organik</span> |
                            @endif
                            @if($product->is_featured)
                                <span style="color:#f59e0b;">⭐ Öne Çıkan</span> |
                            @endif
                            SKU: {{ $product->sku ?? 'Yok' }}
                        </div>
                    </td>
                    <td>{{ $product->category->name ?? 'Kategori Yok' }}</td>
                    <td>
                        <strong>{{ number_format($product->price, 2, ',', '.') }} TL</strong>
                        @if($product->sale_price)
                            <div style="text-decoration:line-through;color:#9ca3af;font-size:12px;">
                                {{ number_format($product->sale_price, 2, ',', '.') }} TL
                            </div>
                        @endif
                    </td>
                    <td>
                        @if($product->sale_price)
                            <strong style="color:#10b981;">{{ number_format($product->sale_price, 2, ',', '.') }} TL</strong>
                            @if($product->price > $product->sale_price)
                                <div style="color:#ef4444;font-size:12px;">
                                    %{{ round((($product->price - $product->sale_price) / $product->price) * 100) }} İndirim
                                </div>
                            @endif
                        @else
                            <span style="color:#9ca3af;">-</span>
                        @endif
                    </td>
                    <td>
                        @if($product->in_stock)
                            <span style="color:#10b981;">✓ Stokta</span>
                            <div style="font-size:12px;color:#6b7280;">{{ $product->stock_quantity }} adet</div>
                        @else
                            <span style="color:#ef4444;">✗ Stokta Yok</span>
                        @endif
                    </td>
                    <td>
                        @if($product->is_active)
                            <span class="badge" style="background:#d1fae5;color:#065f46;">Aktif</span>
                        @else
                            <span class="badge" style="background:#fee2e2;color:#991b1b;">Pasif</span>
                        @endif
                    </td>
                    <td>
                        <div class="flex">
                            <a class="btn btn-sm" href="{{ route('admin.products.edit', $product) }}" style="font-size:12px;padding:6px 12px;">Düzenle</a>
                            <form action="{{ route('admin.products.destroy', $product) }}" method="POST" style="display:inline;" onsubmit="return confirm('Bu ürünü silmek istediğinize emin misiniz?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" style="font-size:12px;padding:6px 12px;">Sil</button>
                            </form>
                        </div>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="8" style="text-align:center;padding:40px;color:#6b7280;">
                        Henüz ürün bulunmuyor. İlk ürünü oluşturun.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>

    @if($products->hasPages())
        <div class="mt" style="display:flex;justify-content:center;">
            {{ $products->links() }}
        </div>
    @endif
</div>
@endsection

