@extends('admin.layout')
@section('content')
<h1>Sayfa Yönetimi</h1>
<div class="mt">
    <a class="btn" href="{{ route('admin.pages.create') }}">Yeni Sayfa Ekle</a>
</div>

@if(session('success'))
    <div class="alert alert-success mt">{{ session('success') }}</div>
@endif

<table class="table mt">
    <thead>
        <tr>
            <th>ID</th>
            <th>Slug</th>
            <th>Başlık</th>
            <th>Durum</th>
            <th>İşlemler</th>
        </tr>
    </thead>
    <tbody>
        @forelse($pages as $page)
            <tr>
                <td>{{ $page->id }}</td>
                <td>{{ $page->slug }}</td>
                <td>{{ $page->title }}</td>
                <td>
                    @if($page->is_active)
                        <span style="color:green;">Aktif</span>
                    @else
                        <span style="color:red;">Pasif</span>
                    @endif
                </td>
                <td>
                    <a class="btn btn-sm" href="{{ route('admin.pages.edit', $page) }}">Düzenle</a>
                    <form action="{{ route('admin.pages.destroy', $page) }}" method="POST" style="display:inline;" onsubmit="return confirm('Emin misiniz?');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger">Sil</button>
                    </form>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="5">Henüz sayfa bulunmuyor.</td>
            </tr>
        @endforelse
    </tbody>
</table>

{{ $pages->links() }}
@endsection

