<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            if (!Schema::hasColumn('products', 'description_detail')) {
                $table->text('description_detail')->nullable()->after('description');
            }
            if (!Schema::hasColumn('products', 'delivery_info')) {
                $table->text('delivery_info')->nullable()->after('description_detail');
            }
            if (!Schema::hasColumn('products', 'certificates_info')) {
                $table->text('certificates_info')->nullable()->after('delivery_info');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            if (Schema::hasColumn('products', 'description_detail')) {
                $table->dropColumn('description_detail');
            }
            if (Schema::hasColumn('products', 'delivery_info')) {
                $table->dropColumn('delivery_info');
            }
            if (Schema::hasColumn('products', 'certificates_info')) {
                $table->dropColumn('certificates_info');
            }
        });
    }
};
