

<?php $__env->startSection('content'); ?>
<h1>Sipariş Yönetimi</h1>

<?php if(session('success')): ?>
    <div style="background:#d4edda;color:#155724;padding:12px;border-radius:4px;margin-bottom:20px;">
        <?php echo e(session('success')); ?>

    </div>
<?php endif; ?>

<div style="margin-bottom:20px;">
    <form method="GET" action="<?php echo e(route('admin.orders.index')); ?>" style="display:flex;gap:10px;flex-wrap:wrap;">
        <select name="status" style="padding:8px;border:1px solid #ddd;border-radius:4px;">
            <option value="">Tüm Durumlar</option>
            <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Beklemede</option>
            <option value="confirmed" <?php echo e(request('status') == 'confirmed' ? 'selected' : ''); ?>>Onaylandı</option>
            <option value="processing" <?php echo e(request('status') == 'processing' ? 'selected' : ''); ?>>Hazırlanıyor</option>
            <option value="shipped" <?php echo e(request('status') == 'shipped' ? 'selected' : ''); ?>>Kargoda</option>
            <option value="delivered" <?php echo e(request('status') == 'delivered' ? 'selected' : ''); ?>>Teslim Edildi</option>
            <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>İptal Edildi</option>
        </select>
        <button type="submit" class="btn">Filtrele</button>
        <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn secondary">Temizle</a>
    </form>
</div>

<?php if($orders->count() > 0): ?>
    <table style="width:100%;border-collapse:collapse;background:#fff;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
        <thead>
            <tr style="background:#f5f5f5;">
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Sipariş No</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Müşteri</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Tutar</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Durum</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Ödeme</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Tarih</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr style="border-bottom:1px solid #eee;">
                    <td style="padding:12px;"><?php echo e($order->order_number); ?></td>
                    <td style="padding:12px;"><?php echo e($order->user->name); ?><br><small style="color:#666;"><?php echo e($order->user->email); ?></small></td>
                    <td style="padding:12px;font-weight:600;color:#7db64f;"><?php echo e(number_format($order->total, 2)); ?> ₺</td>
                    <td style="padding:12px;">
                        <span style="padding:4px 12px;background:#f0f0f0;border-radius:4px;font-size:12px;">
                            <?php if($order->status == 'pending'): ?> Beklemede
                            <?php elseif($order->status == 'confirmed'): ?> Onaylandı
                            <?php elseif($order->status == 'processing'): ?> Hazırlanıyor
                            <?php elseif($order->status == 'shipped'): ?> Kargoda
                            <?php elseif($order->status == 'delivered'): ?> Teslim Edildi
                            <?php elseif($order->status == 'cancelled'): ?> İptal Edildi
                            <?php endif; ?>
                        </span>
                    </td>
                    <td style="padding:12px;">
                        <span style="padding:4px 12px;background:#e8f5e9;border-radius:4px;font-size:12px;">
                            <?php if($order->payment_status == 'paid'): ?> Ödendi
                            <?php elseif($order->payment_status == 'pending'): ?> Bekleniyor
                            <?php elseif($order->payment_status == 'failed'): ?> Başarısız
                            <?php elseif($order->payment_status == 'refunded'): ?> İade Edildi
                            <?php endif; ?>
                        </span>
                    </td>
                    <td style="padding:12px;color:#666;font-size:13px;"><?php echo e($order->created_at->format('d.m.Y H:i')); ?></td>
                    <td style="padding:12px;">
                        <a href="<?php echo e(route('admin.orders.show', $order)); ?>" class="btn" style="padding:6px 12px;font-size:12px;">Detay</a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div style="margin-top:20px;">
        <?php echo e($orders->links()); ?>

    </div>
<?php else: ?>
    <p style="padding:40px;text-align:center;color:#666;">Henüz sipariş bulunmuyor.</p>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/admin/orders/index.blade.php ENDPATH**/ ?>