@php
    $footerMenu = app(\App\Services\MenuService::class)->get('footer');

    $renderMenu = function ($items) use (&$renderMenu) {
        if (!$items || $items->isEmpty()) {
            return;
        }
        echo '<ul class="footer-menu">';
        foreach ($items as $item) {
            if (!$item->is_active) {
                continue;
            }
            $href = $item->url ?? ($item->route_name ? route($item->route_name, $item->route_params ?? []) : '#');
            $target = $item->target ?? '_self';
            echo '<li>';
            echo '<a href="'.e($href).'" target="'.e($target).'">'.e($item->title).'</a>';
            if ($item->children && $item->children->isNotEmpty()) {
                $renderMenu($item->children);
            }
            echo '</li>';
        }
        echo '</ul>';
    };
@endphp

<footer class="dynamic-footer">
    <div class="container">
        <div class="footer-brand">
            <a href="{{ route('home') }}">{{ config('app.name', 'Site') }}</a>
        </div>
        <div class="footer-nav">
            @if($footerMenu && $footerMenu->items)
                {!! $renderMenu($footerMenu->items) !!}
            @endif
        </div>
    </div>
</footer>


