@extends('member.layout')
@section('member-content')
<div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:30px;flex-wrap:wrap;gap:16px;">
    <h1 style="margin:0;color:#414141;font-size:24px;font-weight:600;">İade/Değişim Talebi Detayı #{{ $return->return_number }}</h1>
    <a href="{{ route('member.returns.index') }}" style="color:#7db64f;text-decoration:none;font-size:14px;font-weight:600;">← Taleplerime Dön</a>
</div>

<div style="display:grid;grid-template-columns:2fr 1fr;gap:24px;margin-bottom:24px;">
    <!-- Talep Bilgileri -->
    <div style="background:#f9f9f9;border-radius:8px;padding:20px;">
        <h2 style="margin:0 0 16px;color:#414141;font-size:18px;font-weight:600;">Talep Bilgileri</h2>
        <div style="display:grid;grid-template-columns:repeat(2, 1fr);gap:16px;">
            <div>
                <div style="font-size:12px;color:#666;margin-bottom:4px;">Talep Tarihi</div>
                <div style="font-weight:600;color:#414141;">{{ $return->created_at->format('d.m.Y H:i') }}</div>
            </div>
            <div>
                <div style="font-size:12px;color:#666;margin-bottom:4px;">Talep Tipi</div>
                <div style="font-weight:600;color:#414141;">
                    @if($return->type == 'return') İade
                    @elseif($return->type == 'exchange') Değişim
                    @elseif($return->type == 'cancellation') İptal
                    @endif
                </div>
            </div>
            <div>
                <div style="font-size:12px;color:#666;margin-bottom:4px;">Durum</div>
                <div style="font-weight:600;color:#414141;">
                    @if($return->status == 'pending') Beklemede
                    @elseif($return->status == 'approved') Onaylandı
                    @elseif($return->status == 'rejected') Reddedildi
                    @elseif($return->status == 'processing') İşleniyor
                    @elseif($return->status == 'completed') Tamamlandı
                    @endif
                </div>
            </div>
            <div>
                <div style="font-size:12px;color:#666;margin-bottom:4px;">Sipariş No</div>
                <div style="font-weight:600;color:#414141;">{{ $return->order->order_number }}</div>
            </div>
        </div>
    </div>

    <!-- Durum -->
    <div style="background:#f9f9f9;border-radius:8px;padding:20px;height:fit-content;">
        <h2 style="margin:0 0 16px;color:#414141;font-size:18px;font-weight:600;">Durum</h2>
        <div style="padding:16px;background:#fff;border-radius:4px;text-align:center;">
            <div style="font-size:32px;margin-bottom:8px;">
                @if($return->status == 'pending') ⏳
                @elseif($return->status == 'approved') ✅
                @elseif($return->status == 'rejected') ❌
                @elseif($return->status == 'processing') 🔄
                @elseif($return->status == 'completed') ✔️
                @endif
            </div>
            <div style="font-weight:600;color:#414141;font-size:16px;">
                @if($return->status == 'pending') Beklemede
                @elseif($return->status == 'approved') Onaylandı
                @elseif($return->status == 'rejected') Reddedildi
                @elseif($return->status == 'processing') İşleniyor
                @elseif($return->status == 'completed') Tamamlandı
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Talep Nedeni -->
<div style="background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:20px;margin-bottom:24px;">
    <h2 style="margin:0 0 16px;color:#414141;font-size:18px;font-weight:600;">Talep Nedeni</h2>
    <div style="color:#414141;line-height:1.8;">{{ $return->reason }}</div>
</div>

<!-- Yönetici Notu -->
@if($return->admin_notes)
<div style="background:#e8f5e9;border:1px solid #c3e6cb;border-radius:8px;padding:20px;margin-bottom:24px;">
    <h2 style="margin:0 0 16px;color:#2e7d32;font-size:18px;font-weight:600;">Yönetici Notu</h2>
    <div style="color:#414141;line-height:1.8;">{{ $return->admin_notes }}</div>
</div>
@endif

<!-- İlgili Ürün -->
@if($return->orderItem)
<div style="background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:20px;">
    <h2 style="margin:0 0 16px;color:#414141;font-size:18px;font-weight:600;">İlgili Ürün</h2>
    <div style="display:flex;gap:16px;">
        <div style="width:80px;height:80px;background:#e5e7eb;border-radius:4px;flex-shrink:0;display:flex;align-items:center;justify-content:center;color:#999;">
            @if($return->orderItem->product_image)
                <img src="{{ $return->orderItem->product_image }}" alt="{{ $return->orderItem->product_name }}" style="width:100%;height:100%;object-fit:cover;border-radius:4px;">
            @else
                📦
            @endif
        </div>
        <div style="flex:1;">
            <div style="font-weight:600;color:#414141;margin-bottom:4px;">{{ $return->orderItem->product_name }}</div>
            <div style="font-size:14px;color:#666;margin-bottom:8px;">Adet: {{ $return->orderItem->quantity }}</div>
            <div style="font-weight:600;color:#7db64f;font-size:16px;">{{ number_format($return->orderItem->total, 2) }} ₺</div>
        </div>
    </div>
</div>
@endif
@endsection

