﻿<!DOCTYPE html>
<html id="htmlGlobal" xmlns="http://www.w3.org/1999/xhtml" xmlns:fb="http://www.facebook.com/2008/fbml" xmlns:og="http://opengraphprotocol.org/schema/" lang="tr" style="margin:0;padding:0;">
@include('partials.head')
<body id="bodyGlobal" class="global_body" data-language="tr" data-currency="try" style="margin:0;padding:0;">
    @include('partials.header_static_final')
    <div class="tm-overlay" onclick="document.body.classList.remove('tm-menu-open');"></div>
    <main id="app-content">
        @if(session('success'))
            <div style="max-width:1180px;margin:20px auto;padding:0 16px;">
                <div style="background:#d4edda;color:#155724;padding:12px 16px;border-radius:4px;border:1px solid #c3e6cb;">
                    {{ session('success') }}
                </div>
            </div>
        @endif
        @yield('content')
    </main>
    <nav class="tm-bottom-nav" aria-label="Alt gezinme">
        <a href="{{ url('/') }}">
            <span class="tm-icon">🏠</span>
            <small>Anasayfa</small>
        </a>
        <a href="#" onclick="document.querySelector('.tm-menu-btn')?.click(); return false;">
            <span class="tm-icon">☰</span>
            <small>Kategoriler</small>
        </a>
        @auth
            <a href="#">
                <span class="tm-icon">👤</span>
                <small>{{ Str::limit(Auth::user()->name, 10) }}</small>
            </a>
        @else
            <a href="{{ route('auth.login') }}">
                <span class="tm-icon">👤</span>
                <small>Üye Girişi</small>
            </a>
        @endauth
        <a href="#">
            <span class="tm-icon">🛒</span>
            <small>Sepetim</small>
        </a>
    </nav>
    @include('partials.footer')
    
    <script>
        // Dropdown açma/kapama - hover ve click desteği
        document.addEventListener('DOMContentLoaded', function() {
            const userMenuWrappers = document.querySelectorAll('.tm-user-menu-wrapper');
            
            userMenuWrappers.forEach(function(wrapper) {
                const userMenu = wrapper.querySelector('.tm-user-menu');
                const dropdown = wrapper.querySelector('.tm-user-dropdown');
                
                if (userMenu && dropdown) {
                    let hoverTimeout;
                    
                    // Tıklama ile aç/kapat (mobil için)
                    userMenu.addEventListener('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        
                        // Diğer tüm dropdown'ları kapat
                        document.querySelectorAll('.tm-user-menu-wrapper').forEach(function(w) {
                            if (w !== wrapper) {
                                w.classList.remove('active');
                            }
                        });
                        
                        // Bu dropdown'u aç/kapat
                        wrapper.classList.toggle('active');
                    });
                    
                    // Hover ile aç (desktop için)
                    wrapper.addEventListener('mouseenter', function() {
                        clearTimeout(hoverTimeout);
                        wrapper.classList.add('active');
                    });
                    
                    // Mouse çıkınca kapat (biraz gecikme ile)
                    wrapper.addEventListener('mouseleave', function() {
                        hoverTimeout = setTimeout(function() {
                            wrapper.classList.remove('active');
                        }, 200);
                    });
                }
            });
            
            // Dropdown dışına tıklanınca kapat (mobil için)
            document.addEventListener('click', function(event) {
                const userMenuWrappers = document.querySelectorAll('.tm-user-menu-wrapper');
                
                userMenuWrappers.forEach(function(wrapper) {
                    if (!wrapper.contains(event.target)) {
                        wrapper.classList.remove('active');
                    }
                });
            });
        });
    </script>
</body>
</html>
