@extends('layouts.app')
@section('content')
<style>
    .category-page-wrapper { max-width: 1200px; margin: 0 auto; padding: 20px 16px; }
    
    /* Breadcrumb */
    .breadcrumb { font-size: 13px; color: #666; margin-bottom: 20px; }
    .breadcrumb a { color: #7db64f; text-decoration: none; }
    .breadcrumb a:hover { text-decoration: underline; }
    .breadcrumb span { color: #999; margin: 0 8px; }
    
    /* Filter and Sort Bar */
    .filter-sort-bar { 
        display: flex; 
        justify-content: space-between; 
        align-items: center; 
        padding: 16px; 
        background: #f9fafb; 
        border-radius: 8px; 
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px;
    }
    .filter-sort-bar select {
        padding: 8px 12px;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        background: #fff;
        font-size: 14px;
        cursor: pointer;
    }
    .product-count {
        font-size: 14px;
        color: #666;
        font-weight: 500;
    }
    
    /* Product Grid */
    .products-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
        gap: 20px;
        margin-bottom: 40px;
    }
    .product-card {
        background: #fff;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        padding: 16px;
        transition: all 0.3s;
        position: relative;
        overflow: hidden;
    }
    .product-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 16px rgba(0,0,0,0.1);
        border-color: #7db64f;
    }
    .product-badge {
        position: absolute;
        top: 12px;
        right: 12px;
        background: #7db64f;
        color: #fff;
        padding: 4px 8px;
        border-radius: 4px;
        font-size: 11px;
        font-weight: 600;
        z-index: 2;
    }
    .product-badge.natural {
        background: #10b981;
    }
    .product-image {
        width: 100%;
        height: 180px;
        object-fit: cover;
        border-radius: 6px;
        margin-bottom: 12px;
        background: #f9fafb;
    }
    .product-rating {
        display: flex;
        align-items: center;
        gap: 4px;
        margin-bottom: 8px;
    }
    .product-rating .stars {
        color: #fbbf24;
        font-size: 14px;
    }
    .product-name {
        font-size: 14px;
        font-weight: 600;
        color: #1f2937;
        margin-bottom: 8px;
        line-height: 1.4;
        min-height: 40px;
    }
    .product-weight {
        font-size: 12px;
        color: #6b7280;
        margin-bottom: 8px;
    }
    .product-brand {
        font-size: 12px;
        color: #9ca3af;
        margin-bottom: 12px;
    }
    .product-price {
        display: flex;
        align-items: center;
        gap: 8px;
        margin-bottom: 12px;
    }
    .product-price .current {
        font-size: 18px;
        font-weight: 700;
        color: #7db64f;
    }
    .product-price .old {
        font-size: 14px;
        color: #9ca3af;
        text-decoration: line-through;
    }
    .product-actions {
        display: flex;
        gap: 8px;
    }
    .quantity-selector {
        display: flex;
        align-items: center;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        overflow: hidden;
    }
    .quantity-selector button {
        background: #f9fafb;
        border: none;
        width: 32px;
        height: 36px;
        cursor: pointer;
        font-size: 16px;
        color: #666;
    }
    .quantity-selector button:hover {
        background: #e5e7eb;
    }
    .quantity-selector input {
        width: 50px;
        height: 36px;
        border: none;
        text-align: center;
        font-size: 14px;
    }
    .add-to-cart-btn {
        flex: 1;
        background: #f97316;
        color: #fff;
        border: none;
        padding: 10px 16px;
        border-radius: 6px;
        font-weight: 600;
        font-size: 13px;
        cursor: pointer;
        transition: all 0.3s;
    }
    .add-to-cart-btn:hover {
        background: #ea580c;
    }
    
    /* Pagination */
    .pagination {
        display: flex;
        justify-content: center;
        gap: 8px;
        margin-top: 40px;
    }
    .pagination a, .pagination span {
        padding: 8px 12px;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        text-decoration: none;
        color: #3f3f3f;
    }
    .pagination a:hover {
        background: #f9fafb;
        border-color: #7db64f;
    }
    .pagination .active {
        background: #7db64f;
        color: #fff;
        border-color: #7db64f;
    }
    
    @media (max-width: 768px) {
        .filter-sort-bar {
            flex-direction: column;
            align-items: stretch;
        }
        .products-grid {
            grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));
            gap: 12px;
        }
        .product-card {
            padding: 12px;
        }
        .product-image {
            height: 140px;
        }
    }
</style>

<div class="category-page-wrapper">
    <!-- Breadcrumb -->
    <div class="breadcrumb">
        <a href="{{ route('home') }}">Anasayfa</a>
        <span>/</span>
        @if($category->parent)
            <a href="{{ route('category.show', $category->parent->slug) }}">{{ $category->parent->name }}</a>
            <span>/</span>
        @endif
        <span>{{ $category->name }}</span>
    </div>

    <!-- Filter and Sort Bar -->
    <div class="filter-sort-bar">
        <div style="display: flex; gap: 12px; align-items: center; flex-wrap: wrap;">
            @if($brands->count() > 0)
                <select name="brand" onchange="window.location.href='{{ route('category.show', $category->slug) }}?brand=' + this.value + '&sort={{ request('sort') }}'">
                    <option value="">Tüm Markalar</option>
                    @foreach($brands as $brand)
                        <option value="{{ $brand }}" {{ request('brand') == $brand ? 'selected' : '' }}>{{ $brand }}</option>
                    @endforeach
                </select>
            @endif
            
            <select name="sort" onchange="window.location.href='{{ route('category.show', $category->slug) }}?sort=' + this.value + '&brand={{ request('brand') }}'">
                <option value="default" {{ request('sort') == 'default' ? 'selected' : '' }}>Varsayılan</option>
                <option value="price_asc" {{ request('sort') == 'price_asc' ? 'selected' : '' }}>Fiyata Göre (Artan)</option>
                <option value="price_desc" {{ request('sort') == 'price_desc' ? 'selected' : '' }}>Fiyata Göre (Azalan)</option>
                <option value="name_asc" {{ request('sort') == 'name_asc' ? 'selected' : '' }}>Ürün Adına Göre (A>Z)</option>
                <option value="name_desc" {{ request('sort') == 'name_desc' ? 'selected' : '' }}>Ürün Adına Göre (Z<A)</option>
                <option value="stock" {{ request('sort') == 'stock' ? 'selected' : '' }}>Stoktakiler</option>
            </select>
        </div>
        
        <div class="product-count">
            {{ $products->total() }} Ürün
        </div>
    </div>

    <!-- Products Grid -->
    @if($products->count() > 0)
        <div class="products-grid">
            @foreach($products as $product)
                <div class="product-card">
                    @if($product->sale_price && $product->sale_price < $product->price)
                        <span class="product-badge">%{{ $product->discount_percentage }} İNDİRİM</span>
                    @endif
                    @if($product->is_featured)
                        <span class="product-badge natural">DOĞAL</span>
                    @endif
                    
                    <img src="{{ $product->image ?? '/assets/placeholder-product.jpg' }}" alt="{{ $product->name }}" class="product-image">
                    
                    <div class="product-rating">
                        <span class="stars">★★★★★</span>
                    </div>
                    
                    <div class="product-name">{{ $product->name }}</div>
                    
                    @if($product->weight)
                        <div class="product-weight">{{ $product->weight }}</div>
                    @endif
                    
                    @if($product->brand)
                        <div class="product-brand">{{ $product->brand }}</div>
                    @endif
                    
                    <div class="product-price">
                        <span class="current">{{ number_format($product->final_price, 2) }} ₺</span>
                        @if($product->sale_price && $product->sale_price < $product->price)
                            <span class="old">{{ number_format($product->price, 2) }} ₺</span>
                        @endif
                    </div>
                    
                    <div class="product-actions">
                        <div class="quantity-selector">
                            <button type="button" onclick="decreaseQuantity({{ $product->id }})">-</button>
                            <input type="number" id="qty-{{ $product->id }}" value="1" min="1" max="{{ $product->stock_quantity }}">
                            <button type="button" onclick="increaseQuantity({{ $product->id }})">+</button>
                        </div>
                        <button class="add-to-cart-btn" onclick="addToCart({{ $product->id }})">SEPETE EKLE</button>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Pagination -->
        <div class="pagination">
            {{ $products->links() }}
        </div>
    @else
        <div style="text-align: center; padding: 60px 20px;">
            <p style="font-size: 18px; color: #6b7280; margin-bottom: 12px;">Bu kategoride henüz ürün bulunmuyor.</p>
            <a href="{{ route('home') }}" style="color: #7db64f; text-decoration: none; font-weight: 600;">Anasayfaya Dön</a>
        </div>
    @endif
</div>

<script>
function increaseQuantity(productId) {
    const input = document.getElementById('qty-' + productId);
    const max = parseInt(input.getAttribute('max'));
    const current = parseInt(input.value);
    if (current < max) {
        input.value = current + 1;
    }
}

function decreaseQuantity(productId) {
    const input = document.getElementById('qty-' + productId);
    const current = parseInt(input.value);
    if (current > 1) {
        input.value = current - 1;
    }
}

function addToCart(productId) {
    const quantity = document.getElementById('qty-' + productId).value;
    // TODO: Implement add to cart functionality
    alert('Ürün sepete eklendi! (Ürün ID: ' + productId + ', Miktar: ' + quantity + ')');
}
</script>
@endsection

