@extends('admin.layout')

@section('content')
    <h1>Admin Kullanıcıları</h1>
    <p>Yeni admin ekleyebilir, mevcutların bilgilerini güncelleyebilir, gerekirse silebilirsiniz.</p>

    <div class="grid grid-2 mt">
        <div>
            <h3>Yeni Admin Ekle</h3>
            <form method="POST" action="{{ route('admin.users.store') }}">
                @csrf
                <input name="name" placeholder="Ad Soyad" required>
                <input name="email" type="email" placeholder="E-posta" required>
                <input name="password" type="password" placeholder="Şifre (min 8 karakter)" required>
                <button class="btn" type="submit">Oluştur</button>
            </form>
        </div>
        <div>
            <h3>Bilgi</h3>
            <p>Varsayılan admin: <code>admin@example.com / Admin123!</code> (seed ile eklenir). Giriş yaptıktan sonra yeni bir admin oluşturup varsayılan hesabı silebilirsiniz.</p>
        </div>
    </div>

    <div class="mt">
        <h3>Mevcut Adminler</h3>
        @if($admins->isEmpty())
            <p>Henüz admin yok.</p>
        @else
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>İsim</th>
                        <th>E-posta</th>
                        <th>İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($admins as $admin)
                        <tr>
                            <td>{{ $admin->id }}</td>
                            <td>{{ $admin->name }}</td>
                            <td>{{ $admin->email }}</td>
                            <td class="flex">
                                <form method="POST" action="{{ route('admin.users.update', $admin) }}">
                                    @csrf
                                    @method('PUT')
                                    <input type="hidden" name="name" value="{{ $admin->name }}">
                                    <input type="hidden" name="email" value="{{ $admin->email }}">
                                    <input type="password" name="password" placeholder="Yeni şifre (opsiyonel)">
                                    <button class="btn secondary" type="submit">Güncelle</button>
                                </form>
                                @if(auth()->id() !== $admin->id)
                                    <form method="POST" action="{{ route('admin.users.destroy', $admin) }}">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn danger" type="submit" onclick="return confirm('Silinsin mi?')">Sil</button>
                                    </form>
                                @else
                                    <span class="badge">Kendi hesabın</span>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif
    </div>
@endsection


