@extends('admin.layout')
@section('content')
@php
    use Illuminate\Support\Str;
@endphp
<h1>Slider Düzenle: {{ $slider->name }}</h1>

<form method="POST" action="{{ route('admin.sliders.update', $slider) }}" enctype="multipart/form-data" class="mt">
    @csrf
    @method('PUT')
    
    <div class="form-group">
        <label>Slider Adı *</label>
        <input type="text" name="name" value="{{ old('name', $slider->name) }}" required class="form-control">
    </div>

    <div class="form-group">
        <label>Slider Tipi *</label>
        <select name="type" class="form-control" required>
            <option value="banner" {{ old('type', $slider->type) == 'banner' ? 'selected' : '' }}>Banner (Görsel Slider)</option>
            <option value="product" {{ old('type', $slider->type) == 'product' ? 'selected' : '' }}>Ürün Slider</option>
        </select>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Sıra</label>
            <input type="number" name="order" value="{{ old('order', $slider->order) }}" class="form-control" min="0">
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', $slider->is_active) ? 'checked' : '' }}>
                Aktif
            </label>
        </div>
    </div>

    <div class="flex mt">
        <button type="submit" class="btn">Güncelle</button>
        <a class="btn secondary" href="{{ route('admin.sliders.index') }}">İptal</a>
    </div>
</form>

<hr style="margin:30px 0;border:none;border-top:2px solid #e5e7eb;">

<h2>Öğe Ekle</h2>

@if($slider->type === 'product')
    <form method="POST" action="{{ route('admin.sliders.addItem', $slider) }}" class="mt">
        @csrf
        <div class="form-row" style="display:grid;grid-template-columns:2fr 1fr;gap:20px;">
            <div class="form-group">
                <label>Ürün Seç *</label>
                <select name="product_id" class="form-control" required>
                    <option value="">Ürün Seçin</option>
                    @foreach($products as $product)
                        @php
                            $exists = $slider->items->where('product_id', $product->id)->count() > 0;
                        @endphp
                        @if(!$exists)
                            <option value="{{ $product->id }}">{{ $product->name }}</option>
                        @endif
                    @endforeach
                </select>
                <small>Slider'da zaten bulunan ürünler listede görünmez</small>
            </div>
            <div class="form-group">
                <label>Sıra</label>
                <input type="number" name="order" value="{{ $slider->items->max('order') + 1 ?? 0 }}" class="form-control" min="0">
            </div>
        </div>
        <button type="submit" class="btn">Ürün Ekle</button>
    </form>
@else
    <form method="POST" action="{{ route('admin.sliders.addItem', $slider) }}" enctype="multipart/form-data" class="mt">
        @csrf
        <div class="form-group">
            <label>Başlık *</label>
            <input type="text" name="title" value="{{ old('title') }}" required class="form-control">
        </div>
        <div class="form-group">
            <label>Açıklama</label>
            <textarea name="description" rows="3" class="form-control">{{ old('description') }}</textarea>
        </div>
        <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
            <div class="form-group">
                <label>Görsel *</label>
                <input type="file" name="image" accept="image/*" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Link</label>
                <input type="text" name="link" value="{{ old('link') }}" class="form-control" placeholder="https://...">
            </div>
        </div>
        <div class="form-group">
            <label>Sıra</label>
            <input type="number" name="order" value="{{ $slider->items->max('order') + 1 ?? 0 }}" class="form-control" min="0">
        </div>
        <button type="submit" class="btn">Banner Ekle</button>
    </form>
@endif

@if(session('success'))
    <div class="alert alert-success mt">{{ session('success') }}</div>
@endif

@if($errors->any())
    <div class="alert alert-danger mt">
        <ul style="margin:0;padding-left:20px;">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<hr style="margin:30px 0;border:none;border-top:2px solid #e5e7eb;">

<h2>Mevcut Öğeler ({{ $slider->items->count() }})</h2>

@if($slider->items->count() > 0)
    <div style="display:grid;grid-template-columns:repeat(auto-fill, minmax(250px, 1fr));gap:20px;margin-top:20px;">
        @foreach($slider->items->sortBy('order') as $item)
            <div style="background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:15px;">
                @if($slider->type === 'product' && $item->product)
                    <img src="{{ $item->product->image ? asset($item->product->image) : asset('images/placeholder.png') }}" alt="{{ $item->product->name }}" style="width:100%;height:150px;object-fit:cover;border-radius:6px;margin-bottom:10px;">
                    <div style="font-weight:600;color:#333;margin-bottom:5px;">{{ $item->product->name }}</div>
                    <div style="font-size:12px;color:#6b7280;margin-bottom:10px;">Sıra: {{ $item->order }}</div>
                @else
                    @if($item->image)
                        <img src="{{ asset($item->image) }}" alt="{{ $item->title }}" style="width:100%;height:150px;object-fit:cover;border-radius:6px;margin-bottom:10px;">
                    @endif
                    <div style="font-weight:600;color:#333;margin-bottom:5px;">{{ $item->title }}</div>
                    @if($item->description)
                        <div style="font-size:12px;color:#6b7280;margin-bottom:5px;">{{ Str::limit($item->description, 50) }}</div>
                    @endif
                    <div style="font-size:12px;color:#6b7280;margin-bottom:10px;">Sıra: {{ $item->order }}</div>
                @endif
                <form action="{{ route('admin.sliders.removeItem', $item) }}" method="POST" onsubmit="return confirm('Bu öğeyi silmek istediğinize emin misiniz?');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-sm btn-danger" style="width:100%;">Kaldır</button>
                </form>
            </div>
        @endforeach
    </div>
@else
    <p style="color:#9ca3af;text-align:center;padding:40px;">Henüz öğe eklenmemiş.</p>
@endif
@endsection

