@extends('admin.layout')
@section('content')
<style>
    .settings-tabs {
        display: flex;
        border-bottom: 2px solid #e5e7eb;
        margin-bottom: 30px;
        flex-wrap: wrap;
    }
    .settings-tab {
        padding: 12px 24px;
        background: #f9fafb;
        border: none;
        border-bottom: 2px solid transparent;
        cursor: pointer;
        font-size: 14px;
        font-weight: 500;
        color: #6b7280;
        transition: all 0.2s;
        margin-right: 4px;
    }
    .settings-tab:hover {
        background: #f3f4f6;
        color: #374151;
    }
    .settings-tab.active {
        background: #fff;
        color: #1f2937;
        border-bottom-color: #3b82f6;
    }
    .settings-tab-content {
        display: none;
    }
    .settings-tab-content.active {
        display: block;
    }
    .settings-section {
        background: #fff;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        padding: 24px;
        margin-bottom: 24px;
    }
    .settings-section h3 {
        margin: 0 0 20px 0;
        font-size: 18px;
        font-weight: 600;
        color: #1f2937;
        padding-bottom: 12px;
        border-bottom: 1px solid #e5e7eb;
    }
    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
        margin-bottom: 20px;
    }
    @media (max-width: 768px) {
        .form-row {
            grid-template-columns: 1fr;
        }
    }
    .file-preview {
        margin-top: 10px;
        padding: 10px;
        background: #f9fafb;
        border-radius: 4px;
        display: inline-block;
    }
    .file-preview img {
        max-height: 60px;
        border: 1px solid #e5e7eb;
        padding: 5px;
        border-radius: 4px;
        background: #fff;
    }
</style>

<h1>Site Ayarları</h1>

@if(session('success'))
    <div class="alert alert-success mt">{{ session('success') }}</div>
@endif

<form method="POST" action="{{ route('admin.settings.update') }}" enctype="multipart/form-data" class="mt">
    @csrf
    @method('PUT')
    
    <div class="settings-tabs">
        <button type="button" class="settings-tab active" onclick="showTab('general')">Genel Ayarlar</button>
        <button type="button" class="settings-tab" onclick="showTab('seo')">SEO Ayarları</button>
        <button type="button" class="settings-tab" onclick="showTab('contact')">İletişim</button>
        <button type="button" class="settings-tab" onclick="showTab('social')">Sosyal Medya</button>
        <button type="button" class="settings-tab" onclick="showTab('shipping')">Kargo & Teslimat</button>
        <button type="button" class="settings-tab" onclick="showTab('payment')">Ödeme</button>
        <button type="button" class="settings-tab" onclick="showTab('return')">İade Politikası</button>
        <button type="button" class="settings-tab" onclick="showTab('analytics')">Analitik & Takip</button>
        <button type="button" class="settings-tab" onclick="showTab('email')">E-posta</button>
        <button type="button" class="settings-tab" onclick="showTab('other')">Diğer</button>
    </div>

    <!-- Genel Ayarlar -->
    <div id="tab-general" class="settings-tab-content active">
        <div class="settings-section">
            <h3>Temel Bilgiler</h3>
            <div class="form-group">
                <label>Site Adı *</label>
                <input type="text" name="site_name" value="{{ old('site_name', $settings['site_name'] ?? '') }}" required class="form-control">
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label>Logo</label>
                    <input type="file" name="site_logo" accept="image/*" class="form-control">
                    @if(isset($settings['site_logo']) && $settings['site_logo'])
                        <div class="file-preview">
                            <img src="{{ $settings['site_logo'] }}" alt="Logo">
                            <p style="margin:5px 0 0 0;font-size:12px;color:#666;">Mevcut logo</p>
                        </div>
                    @endif
                    <small>PNG, JPG, GIF veya SVG, maksimum 2MB</small>
                </div>

                <div class="form-group">
                    <label>Favicon</label>
                    <input type="file" name="site_favicon" accept="image/png,image/x-icon" class="form-control">
                    @if(isset($settings['site_favicon']) && $settings['site_favicon'])
                        <div class="file-preview">
                            <img src="{{ $settings['site_favicon'] }}" alt="Favicon">
                            <p style="margin:5px 0 0 0;font-size:12px;color:#666;">Mevcut favicon</p>
                        </div>
                    @endif
                    <small>PNG veya ICO formatında, maksimum 1MB (32x32 veya 16x16 önerilir)</small>
                </div>
            </div>

            <div class="form-group">
                <label>Site Açıklaması</label>
                <textarea name="site_description" rows="3" class="form-control">{{ old('site_description', $settings['site_description'] ?? '') }}</textarea>
            </div>

            <div class="form-group">
                <label>Site Anahtar Kelimeleri</label>
                <input type="text" name="site_keywords" value="{{ old('site_keywords', $settings['site_keywords'] ?? '') }}" class="form-control" placeholder="kelime1, kelime2, kelime3">
                <small>Virgülle ayrılmış anahtar kelimeler</small>
            </div>

            <div class="form-group">
                <label>Telif Hakkı Metni</label>
                <input type="text" name="copyright_text" value="{{ old('copyright_text', $settings['copyright_text'] ?? '') }}" class="form-control">
            </div>
        </div>
    </div>

    <!-- SEO Ayarları -->
    <div id="tab-seo" class="settings-tab-content">
        <div class="settings-section">
            <h3>SEO Ayarları</h3>
            <div class="form-group">
                <label>Meta Başlık (Title)</label>
                <input type="text" name="meta_title" value="{{ old('meta_title', $settings['meta_title'] ?? '') }}" class="form-control" maxlength="60">
                <small>Maksimum 60 karakter önerilir</small>
            </div>

            <div class="form-group">
                <label>Meta Açıklama (Description)</label>
                <textarea name="meta_description" rows="3" class="form-control" maxlength="160">{{ old('meta_description', $settings['meta_description'] ?? '') }}</textarea>
                <small>Maksimum 160 karakter önerilir</small>
            </div>

            <div class="form-group">
                <label>Meta Anahtar Kelimeleri</label>
                <input type="text" name="meta_keywords" value="{{ old('meta_keywords', $settings['meta_keywords'] ?? '') }}" class="form-control" placeholder="kelime1, kelime2, kelime3">
                <small>Virgülle ayrılmış anahtar kelimeler</small>
            </div>
        </div>
    </div>

    <!-- İletişim -->
    <div id="tab-contact" class="settings-tab-content">
        <div class="settings-section">
            <h3>İletişim Bilgileri</h3>
            <div class="form-row">
                <div class="form-group">
                    <label>Telefon</label>
                    <input type="text" name="contact_phone" value="{{ old('contact_phone', $settings['contact_phone'] ?? '') }}" class="form-control">
                </div>

                <div class="form-group">
                    <label>E-posta</label>
                    <input type="email" name="contact_email" value="{{ old('contact_email', $settings['contact_email'] ?? '') }}" class="form-control">
                </div>
            </div>

            <div class="form-group">
                <label>Adres</label>
                <textarea name="contact_address" rows="3" class="form-control">{{ old('contact_address', $settings['contact_address'] ?? '') }}</textarea>
            </div>

            <div class="form-group">
                <label>Çalışma Saatleri</label>
                <input type="text" name="contact_working_hours" value="{{ old('contact_working_hours', $settings['contact_working_hours'] ?? '') }}" class="form-control" placeholder="Örn: Pazartesi - Cuma: 09:00 - 18:00">
            </div>
        </div>
    </div>

    <!-- Sosyal Medya -->
    <div id="tab-social" class="settings-tab-content">
        <div class="settings-section">
            <h3>Sosyal Medya Hesapları</h3>
            <div class="form-group">
                <label>Facebook URL</label>
                <input type="url" name="social_facebook" value="{{ old('social_facebook', $settings['social_facebook'] ?? '') }}" class="form-control" placeholder="https://facebook.com/tazemasa">
            </div>

            <div class="form-group">
                <label>Instagram URL</label>
                <input type="url" name="social_instagram" value="{{ old('social_instagram', $settings['social_instagram'] ?? '') }}" class="form-control" placeholder="https://instagram.com/tazemasa">
            </div>

            <div class="form-group">
                <label>Twitter URL</label>
                <input type="url" name="social_twitter" value="{{ old('social_twitter', $settings['social_twitter'] ?? '') }}" class="form-control" placeholder="https://twitter.com/tazemasa">
            </div>

            <div class="form-group">
                <label>YouTube URL</label>
                <input type="url" name="social_youtube" value="{{ old('social_youtube', $settings['social_youtube'] ?? '') }}" class="form-control" placeholder="https://youtube.com/tazemasa">
            </div>

            <div class="form-group">
                <label>LinkedIn URL</label>
                <input type="url" name="social_linkedin" value="{{ old('social_linkedin', $settings['social_linkedin'] ?? '') }}" class="form-control" placeholder="https://linkedin.com/company/tazemasa">
            </div>
        </div>
    </div>

    <!-- Kargo & Teslimat -->
    <div id="tab-shipping" class="settings-tab-content">
        <div class="settings-section">
            <h3>Kargo ve Teslimat Ayarları</h3>
            <div class="form-row">
                <div class="form-group">
                    <label>Ücretsiz Kargo Eşiği (TL)</label>
                    <input type="number" name="shipping_free_threshold" value="{{ old('shipping_free_threshold', $settings['shipping_free_threshold'] ?? '') }}" class="form-control" step="0.01" min="0">
                    <small>Bu tutarın üzerindeki siparişlerde ücretsiz kargo</small>
                </div>

                <div class="form-group">
                    <label>Kargo Ücreti (TL)</label>
                    <input type="number" name="shipping_cost" value="{{ old('shipping_cost', $settings['shipping_cost'] ?? '') }}" class="form-control" step="0.01" min="0">
                    <small>Standart kargo ücreti</small>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label>Teslimat Süresi</label>
                    <input type="text" name="shipping_delivery_days" value="{{ old('shipping_delivery_days', $settings['shipping_delivery_days'] ?? '') }}" class="form-control" placeholder="Örn: 1-3 iş günü">
                </div>

                <div class="form-group">
                    <label>Minimum Sipariş Tutarı (TL)</label>
                    <input type="number" name="min_order_amount" value="{{ old('min_order_amount', $settings['min_order_amount'] ?? '') }}" class="form-control" step="0.01" min="0">
                </div>
            </div>
        </div>
    </div>

    <!-- Ödeme -->
    <div id="tab-payment" class="settings-tab-content">
        <div class="settings-section">
            <h3>Ödeme Ayarları</h3>
            <div class="form-group">
                <label>Ödeme Yöntemleri</label>
                <input type="text" name="payment_methods" value="{{ old('payment_methods', $settings['payment_methods'] ?? '') }}" class="form-control" placeholder="Kredi Kartı, Havale/EFT, Kapıda Ödeme">
                <small>Virgülle ayrılmış ödeme yöntemleri</small>
            </div>

            <div class="form-group">
                <label>Banka Hesap Bilgileri</label>
                <textarea name="bank_accounts" rows="6" class="form-control" placeholder="Banka adı, şube, hesap no, IBAN bilgileri...">{{ old('bank_accounts', $settings['bank_accounts'] ?? '') }}</textarea>
            </div>
        </div>
    </div>

    <!-- İade Politikası -->
    <div id="tab-return" class="settings-tab-content">
        <div class="settings-section">
            <h3>İade ve İptal Politikası</h3>
            <div class="form-group">
                <label>İade Süresi (Gün)</label>
                <input type="number" name="return_policy_days" value="{{ old('return_policy_days', $settings['return_policy_days'] ?? '') }}" class="form-control" min="0">
                <small>Teslimat tarihinden itibaren kaç gün içinde iade yapılabilir</small>
            </div>

            <div class="form-group">
                <label>İade Politikası Metni</label>
                <textarea name="return_policy_text" rows="5" class="form-control">{{ old('return_policy_text', $settings['return_policy_text'] ?? '') }}</textarea>
            </div>
        </div>
    </div>

    <!-- Analitik & Takip -->
    <div id="tab-analytics" class="settings-tab-content">
        <div class="settings-section">
            <h3>Analitik ve Takip Kodları</h3>
            <div class="form-group">
                <label>Google Analytics ID</label>
                <input type="text" name="google_analytics_id" value="{{ old('google_analytics_id', $settings['google_analytics_id'] ?? '') }}" class="form-control" placeholder="G-XXXXXXXXXX">
            </div>

            <div class="form-group">
                <label>Facebook Pixel ID</label>
                <input type="text" name="facebook_pixel_id" value="{{ old('facebook_pixel_id', $settings['facebook_pixel_id'] ?? '') }}" class="form-control" placeholder="123456789012345">
            </div>

            <div class="form-group">
                <label>Google Tag Manager ID</label>
                <input type="text" name="google_tag_manager_id" value="{{ old('google_tag_manager_id', $settings['google_tag_manager_id'] ?? '') }}" class="form-control" placeholder="GTM-XXXXXXX">
            </div>
        </div>
    </div>

    <!-- E-posta -->
    <div id="tab-email" class="settings-tab-content">
        <div class="settings-section">
            <h3>E-posta Ayarları</h3>
            <div class="form-row">
                <div class="form-group">
                    <label>Gönderen Adı</label>
                    <input type="text" name="email_from_name" value="{{ old('email_from_name', $settings['email_from_name'] ?? '') }}" class="form-control">
                </div>

                <div class="form-group">
                    <label>Gönderen E-posta</label>
                    <input type="email" name="email_from_address" value="{{ old('email_from_address', $settings['email_from_address'] ?? '') }}" class="form-control">
                </div>
            </div>
        </div>
    </div>

    <!-- Diğer -->
    <div id="tab-other" class="settings-tab-content">
        <div class="settings-section">
            <h3>Para Puan Ayarları</h3>
            <div class="form-row">
                <div class="form-group">
                    <label>Para Puan Oranı</label>
                    <input type="number" name="para_puan_rate" value="{{ old('para_puan_rate', $settings['para_puan_rate'] ?? '') }}" class="form-control" step="0.01" min="0">
                    <small>1 TL = Kaç Para Puan (örn: 1)</small>
                </div>

                <div class="form-group">
                    <label>Minimum Kullanım Tutarı (TL)</label>
                    <input type="number" name="para_puan_min_usage" value="{{ old('para_puan_min_usage', $settings['para_puan_min_usage'] ?? '') }}" class="form-control" step="0.01" min="0">
                </div>
            </div>
        </div>

        <div class="settings-section">
            <h3>Bakım Modu</h3>
            <div class="form-group">
                <label>
                    <input type="checkbox" name="maintenance_mode" value="1" {{ old('maintenance_mode', $settings['maintenance_mode'] ?? '0') == '1' ? 'checked' : '' }}>
                    Bakım modunu aktif et
                </label>
                <small>Sitemiz bakımdayken ziyaretçiler bu mesajı görecek</small>
            </div>

            <div class="form-group">
                <label>Bakım Mesajı</label>
                <textarea name="maintenance_message" rows="3" class="form-control">{{ old('maintenance_message', $settings['maintenance_message'] ?? '') }}</textarea>
            </div>
        </div>
    </div>

    <div style="margin-top: 30px; padding-top: 20px; border-top: 2px solid #e5e7eb;">
        <button type="submit" class="btn">Tüm Ayarları Kaydet</button>
        <a class="btn secondary" href="{{ route('admin.dashboard') }}">İptal</a>
    </div>
</form>

<script>
function showTab(tabName) {
    // Tüm tab içeriklerini gizle
    document.querySelectorAll('.settings-tab-content').forEach(content => {
        content.classList.remove('active');
    });
    
    // Tüm tab butonlarını pasif yap
    document.querySelectorAll('.settings-tab').forEach(tab => {
        tab.classList.remove('active');
    });
    
    // Seçilen tab içeriğini göster
    document.getElementById('tab-' + tabName).classList.add('active');
    
    // Seçilen tab butonunu aktif yap
    event.target.classList.add('active');
}
</script>
@endsection
