@extends('admin.layout')

@section('content')
<h1>Sipariş Detayı #{{ $order->order_number }}</h1>

@if(session('success'))
    <div style="background:#d4edda;color:#155724;padding:12px;border-radius:4px;margin-bottom:20px;">
        {{ session('success') }}
    </div>
@endif

<div style="display:grid;grid-template-columns:2fr 1fr;gap:20px;margin-bottom:20px;">
    <div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
        <h2>Müşteri Bilgileri</h2>
        <p><strong>Ad:</strong> {{ $order->user->name }}</p>
        <p><strong>E-posta:</strong> {{ $order->user->email }}</p>
        <p><strong>Telefon:</strong> {{ $order->user->phone ?? 'Belirtilmemiş' }}</p>
    </div>
    <div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
        <h2>Durum Güncelle</h2>
        <form method="POST" action="{{ route('admin.orders.updateStatus', $order) }}">
            @csrf
            @method('PUT')
            <div style="margin-bottom:12px;">
                <label style="display:block;margin-bottom:4px;">Sipariş Durumu</label>
                <select name="status" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:4px;">
                    <option value="pending" {{ $order->status == 'pending' ? 'selected' : '' }}>Beklemede</option>
                    <option value="confirmed" {{ $order->status == 'confirmed' ? 'selected' : '' }}>Onaylandı</option>
                    <option value="processing" {{ $order->status == 'processing' ? 'selected' : '' }}>Hazırlanıyor</option>
                    <option value="shipped" {{ $order->status == 'shipped' ? 'selected' : '' }}>Kargoda</option>
                    <option value="delivered" {{ $order->status == 'delivered' ? 'selected' : '' }}>Teslim Edildi</option>
                    <option value="cancelled" {{ $order->status == 'cancelled' ? 'selected' : '' }}>İptal Edildi</option>
                </select>
            </div>
            <div style="margin-bottom:12px;">
                <label style="display:block;margin-bottom:4px;">Ödeme Durumu</label>
                <select name="payment_status" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:4px;">
                    <option value="pending" {{ $order->payment_status == 'pending' ? 'selected' : '' }}>Bekleniyor</option>
                    <option value="paid" {{ $order->payment_status == 'paid' ? 'selected' : '' }}>Ödendi</option>
                    <option value="failed" {{ $order->payment_status == 'failed' ? 'selected' : '' }}>Başarısız</option>
                    <option value="refunded" {{ $order->payment_status == 'refunded' ? 'selected' : '' }}>İade Edildi</option>
                </select>
            </div>
            <button type="submit" class="btn">Güncelle</button>
        </form>
    </div>
</div>

<div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);margin-bottom:20px;">
    <h2>Sipariş Özeti</h2>
    <table style="width:100%;border-collapse:collapse;">
        <tr>
            <td style="padding:8px;border-bottom:1px solid #eee;">Ara Toplam</td>
            <td style="padding:8px;text-align:right;border-bottom:1px solid #eee;">{{ number_format($order->subtotal, 2) }} ₺</td>
        </tr>
        <tr>
            <td style="padding:8px;border-bottom:1px solid #eee;">Kargo</td>
            <td style="padding:8px;text-align:right;border-bottom:1px solid #eee;">{{ number_format($order->shipping_cost, 2) }} ₺</td>
        </tr>
        @if($order->discount > 0)
        <tr>
            <td style="padding:8px;border-bottom:1px solid #eee;">İndirim</td>
            <td style="padding:8px;text-align:right;border-bottom:1px solid #eee;color:#e74c3c;">-{{ number_format($order->discount, 2) }} ₺</td>
        </tr>
        @endif
        <tr>
            <td style="padding:8px;font-weight:bold;">Toplam</td>
            <td style="padding:8px;text-align:right;font-weight:bold;color:#7db64f;font-size:18px;">{{ number_format($order->total, 2) }} ₺</td>
        </tr>
    </table>
</div>

<div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
    <h2>Sipariş Edilen Ürünler</h2>
    <table style="width:100%;border-collapse:collapse;">
        <thead>
            <tr style="background:#f5f5f5;">
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Ürün</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Adet</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Birim Fiyat</th>
                <th style="padding:12px;text-align:right;border-bottom:2px solid #ddd;">Toplam</th>
            </tr>
        </thead>
        <tbody>
            @foreach($order->items as $item)
                <tr>
                    <td style="padding:12px;border-bottom:1px solid #eee;">{{ $item->product_name }}</td>
                    <td style="padding:12px;border-bottom:1px solid #eee;">{{ $item->quantity }}</td>
                    <td style="padding:12px;border-bottom:1px solid #eee;">{{ number_format($item->price, 2) }} ₺</td>
                    <td style="padding:12px;text-align:right;border-bottom:1px solid #eee;font-weight:600;">{{ number_format($item->total, 2) }} ₺</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

<div style="margin-top:20px;">
    <a href="{{ route('admin.orders.index') }}" class="btn secondary">← Geri Dön</a>
</div>
@endsection

