<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->boolean('is_organic')->default(false)->after('is_featured');
            $table->string('farm_name')->nullable()->after('brand');
            $table->string('origin')->nullable()->after('farm_name');
            $table->integer('rating')->default(0)->change(); // Make sure rating is integer (0-5)
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn(['is_organic', 'farm_name', 'origin']);
        });
    }
};
