<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Slider extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'type',
        'is_active',
        'order',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'order' => 'integer',
    ];

    /**
     * Get the items for the slider
     */
    public function items(): HasMany
    {
        return $this->hasMany(SliderItem::class)->orderBy('order');
    }

    /**
     * Get active items for the slider
     */
    public function activeItems(): HasMany
    {
        return $this->hasMany(SliderItem::class)
            ->where('is_active', true)
            ->orderBy('order');
    }
}
