<?php

namespace App\Http\Controllers\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        
        $stats = [
            'total_orders' => $user->orders()->count(),
            'pending_orders' => $user->orders()->where('status', 'pending')->count(),
            'total_addresses' => $user->addresses()->count(),
            'total_favorites' => $user->favorites()->count(),
        ];

        $recent_orders = $user->orders()
            ->with('items')
            ->latest()
            ->take(5)
            ->get();

        return view('member.dashboard', compact('stats', 'recent_orders'));
    }

    public function paraPuanlarim()
    {
        $user = Auth::user();
        $paraPuan = $user->para_puan ?? 0;
        
        return view('member.para-puanlarim', compact('paraPuan'));
    }
}
