#!/bin/bash

# Laravel Hızlı Kurulum Scripti
# Kullanım: bash QUICK_DEPLOY.sh

echo "🚀 Laravel Production Kurulumu Başlıyor..."

# 1. Composer bağımlılıklarını yükle
echo "📦 Composer bağımlılıkları yükleniyor..."
composer install --optimize-autoloader --no-dev

# 2. .env dosyası kontrolü
if [ ! -f .env ]; then
    echo "📝 .env dosyası oluşturuluyor..."
    cp .env.example .env
    echo "⚠️  LÜTFEN .env DOSYASINI DÜZENLEYİN!"
    echo "   - Veritabanı bilgilerini girin"
    echo "   - APP_URL'yi ayarlayın"
    echo "   - APP_DEBUG=false yapın"
    read -p "Devam etmek için Enter'a basın..."
fi

# 3. Application key
if grep -q "APP_KEY=$" .env; then
    echo "🔑 Application key oluşturuluyor..."
    php artisan key:generate
fi

# 4. Veritabanı migration
echo "🗄️  Veritabanı migration'ları çalıştırılıyor..."
read -p "Veritabanı migration'larını çalıştırmak istiyor musunuz? (y/n) " -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
    php artisan migrate --force
fi

# 5. Storage link
echo "🔗 Storage link oluşturuluyor..."
php artisan storage:link

# 6. İzinler
echo "🔐 Klasör izinleri ayarlanıyor..."
chmod -R 775 storage bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache 2>/dev/null || echo "⚠️  chown komutu çalıştırılamadı, manuel olarak yapın"

# 7. Cache temizleme
echo "🧹 Cache temizleniyor..."
php artisan config:clear
php artisan route:clear
php artisan view:clear
php artisan cache:clear

# 8. Cache oluşturma
echo "⚡ Cache oluşturuluyor..."
php artisan config:cache
php artisan route:cache
php artisan view:cache

# 9. Uploads klasörü
echo "📁 Uploads klasörleri oluşturuluyor..."
mkdir -p public/uploads/categories
mkdir -p public/uploads/products
mkdir -p public/uploads/campaigns
mkdir -p public/uploads/sliders
chmod -R 775 public/uploads

echo "✅ Kurulum tamamlandı!"
echo ""
echo "📋 Yapılması gerekenler:"
echo "   1. .env dosyasını düzenleyin"
echo "   2. Web sunucusu yapılandırmasını yapın"
echo "   3. SSL sertifikası kurun (önerilir)"
echo "   4. Veritabanını oluşturun ve migration'ları çalıştırın"
echo ""
echo "🔍 Kontrol edin:"
echo "   - storage/ ve bootstrap/cache/ yazılabilir mi?"
echo "   - public/uploads/ klasörleri var mı?"
echo "   - .env dosyası doğru yapılandırılmış mı?"

